// ------------------------------------
//      Desktop interface Library
//            Version 1.0
//    by: Harry Konstas March 20/2000
// ------------------------------------

#include "OBLdos.h"
 
// tFRM
#define MainForm 1000
#define InForm 1100

// buttons
#define InOK 1101
#define InCancel 1102
#define InField 1103

// MENU 
#define MenuAbout 1101
#define MenuQuit 1102

// Other
#define VOFFSET 10
#define SHEETW 320
#define SHEETH 150
#define FLDSHIFT -1

typedef struct{ 
  Word second; 
  Word minute; 
  Word hour; 
  Word day; 
  Word month; 
  Word year; 
  Word weekDay;
}DateTimeType; 

typedef DateTimeType * DateTimePtr; 

void TimSecondsToDateTime(ULong seconds, DateTimePtr dateTimeP) SYS_TRAP(sysTrapTimSecondsToDateTime);
ULong TimGetSeconds(void) SYS_TRAP(sysTrapTimGetSeconds);

// ------------------------------------ 
//              Globals
// ------------------------------------

int Main(void);

// globals
int KEY=0;
char *pPassword;
char WinTitle[80];
int PenX=-1,PenY=-1,vshift=0;

WinHandle workH;
int SheetX=80,SheetY=0;
int SheetW=SHEETW, SheetH=SHEETH;

STDOUT *pStd;  // stdout
DOCFILE *pLPT; // printer log
UInt FfsRef;   // file system
char rscfile[80]; // resource file

// ------------------------------------ 
//             UTILITIES
// ------------------------------------

void EditColors(void){};
void ShowColors(void){};

void Beep(void)
{
  SndPlaySystemSound(1);
}

void AppLaunch(char *fname)
{
  KEY=_F10;
  AppSwitch(fname);
}

int CheckPrinter(void)
{
  return 1;
}

int SendPrinter(char *s)
{
  WriteDoc(pLPT,s);
  return 1;
}

void Alert(int rscnum)
{
  char buf[100];

  Beep();
  GetResource(STR,rscnum,buf);
  MsgBox(buf,NULL);
}

void FatalExit(char *msg)
{ 

  EventType evt;

  Beep();
  ErrorBox("!",msg);
  evt.eType = appStopEvent;
  EvtAddEventToQueue(&evt);

}

void SendScreen(char *s)
{
  WriteStdout(pStd,s);
}

void WaitMsg(void)
{
  RectanglePtr rPtr;

  rPtr=MemPtrNew(sizeof(RectangleType));

  RctSetRectangle(rPtr,40,60,80,32);
  WinEraseRectangle(rPtr,0);
  WinDrawRectangleFrame(1,rPtr);
  RctSetRectangle(rPtr,43,63,74,26);
  WinDrawRectangleFrame(2,rPtr);
  WinDrawChars("Busy...",7,70,72);
  MemPtrFree(rPtr);
}

void clrscr(void)
{
  ClearStdout(pStd);
}

int GetInput(char *title,char *buffer)
{

  int r;
  FormPtr frmP,frm2P;
  char *inbuf;

  frmP = FrmGetActiveForm(); 
  frm2P=FrmInitForm(InForm);
  FrmSetActiveForm(frm2P);
  FrmSetTitle(frm2P,title);
  SetTextToObject(InField, buffer);

  r=FrmDoDialog(frm2P);

  if(r==InOK) {
    inbuf=GetTextFromObject(InField);
    StrCopy(buffer,inbuf);
  }

  FrmSetActiveForm(frmP);
  FrmDrawForm(frmP);
  FrmDeleteForm(frm2P);

  if(r==InOK) return 1;
  return 0;

}

char *getpass(char *prompt)
{
  pPassword[0]=0;
  GetInput("Enter Password",pPassword);
  return pPassword;

}

char *GetDate(char *buffer)
{

  DateTimePtr pD;

  pD=MemPtrNew(sizeof(DateTimeType));

  TimSecondsToDateTime(TimGetSeconds(),pD);
  StrPrintF(buffer,"%02d/%02d/%02d",
          pD->month, pD->day, pD->year);

  MemPtrFree(pD);
  return buffer;

}

char *itoa(int v,char *buffer,int base)
{
  StrPrintF(buffer,"%d",v);
  return buffer;
}

int atoi(char *buffer)
{
  int v;

  v=(int)StrAToI(buffer);
  return v;
}

char *ltoa(long v,char *buffer,int base)
{
  LongToA(v,buffer);
  return buffer;
}

int FindTstart(char *buf, int start)
{

  while(buf[start]!=95 && buf[start]!=0) start++;
  return start;

}

int FindTend(char *buf, int start)
{

  while(buf[start]>32) start++;
  return start;

}

// ------------------------------------ 
//            FILE ACCESS
// ------------------------------------

int open(char *fname, int flags, int mode)
{
  return FfsOpen(FfsRef,fname,flags,mode);
}

int close(int h)
{
  int r;

  r=FfsClose(FfsRef,h);

  return r;
}

int read(int h,void *buf,int size)
{
  return FfsRead(FfsRef,h,buf,size); 
}

int write(int h,void *buf,int size)
{
  return FfsWrite(FfsRef,h,buf,size); 
}

long lseek(int h,long offset,int origin)
{
  return FfsLseek(FfsRef,h,offset,origin); 
}

int remove(char *fname)
{
  return FfsRemove(FfsRef,fname); 
}

int rename(char *oldname,char *newname)
{
  return FfsRename(FfsRef,oldname,newname); 
}

// ------------------------------------ 
//        VIRTUAL 80x25 SHEET
// ------------------------------------

void CreateSheet(void)
{

  SWord w,h;
  WinHandle mainH; 
  Word error;

  mainH=WinGetActiveWindow();
  workH=WinCreateOffscreenWindow(SHEETW,SHEETH,screenFormat,&error);
  WinSetDrawWindow(workH);
  WinEraseWindow();
  WinSetDrawWindow(mainH);

}


void DisplaySheet(Word originX, Word originY)
{

  FormPtr frmP;
  WinHandle mainH;
  RectanglePtr rPtr;

  mainH=WinGetActiveWindow();
  rPtr=MemPtrNew(sizeof(RectangleType));

  RctSetRectangle(rPtr,originX,originY,160,160-VOFFSET);
  WinCopyRectangle(workH,mainH,rPtr,0,VOFFSET,scrCopy);

  MemPtrFree(rPtr);

  frmP = FrmGetActiveForm(); 
  FrmDrawForm(frmP);
 
}

void PanSheet(int slide, int scroll, int *origX, int *origY)
{

  WinHandle mainH;
  int fx=0,fy=0,tx,ty,xd,yd,oX=0,oY=0;
  SWord sheetW,sheetH;
  Boolean t=0,flag=0;

  oX=*origX; oY=*origY;

  mainH=WinGetActiveWindow();
  WinSetDrawWindow(workH);
  WinGetWindowExtent(&sheetW,&sheetH);
  WinSetDrawWindow(mainH);

  EvtGetPen(&fx,&fy,&t);

  while(t&fy>VOFFSET&fy<160) { 
    EvtGetPen(&tx,&ty,&t); 

    if(t) {
      PenX=tx; PenY=ty;
    }

    if(!t) break;
    if(tx>fx) xd=tx-fx; else xd=fx-tx;

    if(xd>slide&&tx<fx) {
      oX+=scroll; fx=tx; 
      if(oX+160>sheetW) oX=sheetW-160;
      DisplaySheet(oX,oY);flag=1;
    }
        
    if(xd>slide&&tx>fx) {
      oX-=scroll; fx=tx; 
      if(oX<0) oX=0;
      DisplaySheet(oX,oY);flag=1;
    }

  }

  *origX=oX; *origY=oY;
  DisplaySheet(oX,oY);

  if(flag==1) {
    PenX=-1; PenY=-1;
  }
  else KEY=1;
}


// ------------------------------------ 
//          WINDOW FUNCTIONS
// ------------------------------------

Window w_open(int X,int Y,int W,int H)
{

  int c;
  Window w;
  WinHandle mainH; 
  RectanglePtr rPtr;

  SheetX=80;

  w=MemPtrNew(sizeof(WND));
  rPtr=MemPtrNew(sizeof(RectangleType));

  X=X*4; Y=Y*6; W++; W=(W*4)+3; H++; H=H*6;
  w->xp=X; w->yp=Y; w->wd=W; w->ht=H;

  mainH=WinGetActiveWindow();
  WinSetDrawWindow(workH);

  RctSetRectangle(rPtr,w->xp,w->yp,w->wd,w->ht);
  WinDrawRectangleFrame(1,rPtr);        
  RctSetRectangle(rPtr,w->xp+2,w->yp+2,w->wd-4,w->ht-4);
  WinDrawRectangleFrame(1,rPtr);        

  if(StrLen(WinTitle)>0) {
    c=(w->wd/2)-((StrLen(WinTitle)/2)*4);
    WinDrawInvertedChars(WinTitle,StrLen(WinTitle),w->xp+c,w->yp-3);
    WinTitle[0]=0;
  }

  WinSetDrawWindow(mainH);
  MemPtrFree(rPtr);

  return w;

}

void w_close(Window w)
{

  WinHandle mainH; 
  RectanglePtr rPtr;

  mainH=WinGetActiveWindow();
  WinSetDrawWindow(workH);

  rPtr=MemPtrNew(sizeof(RectangleType));
  RctSetRectangle(rPtr,0,0,320,160-VOFFSET);
  WinEraseRectangle(rPtr,0);        

  WinSetDrawWindow(mainH);
  DisplaySheet(SheetX,SheetY);

  MemPtrFree(rPtr);
  MemPtrFree(w);

}

void printw(Window w,int x,int y,char *text)
{

  int xp,yp;
  FormPtr frmP;
  WinHandle mainH; 

  if(StrLen(text)>80) text[81]=0;
  if(StrLen(text)==0) return;
  StripLF(text);

  mainH=WinGetActiveWindow();
  WinSetDrawWindow(workH);

  xp=w->xp+(x*4)+3;
  yp=w->yp+(y*6)+3+vshift;

  WinDrawChars(text,StrLen(text),xp,yp);
  WinSetDrawWindow(mainH);

  frmP = FrmGetActiveForm(); 
  FrmDrawForm(frmP);
 
}

void w_lineh(Window w,char t,int cstart,int cend,int r)
{

  int f;
  char buf[4];

  buf[0]=t; buf[1]=0;
  for(f=cstart;f<=cend;f++) {
    printw(w,f,r,buf);
  }

}

void w_linev(Window w,char t,int rstart,int rend,int c)
{
  int f;
  char buf[4];

  buf[0]=t; buf[1]=0;

  for(f=rstart;f<=rend;f++) {
    printw(w,c,f,buf);
  }
}

// ------------------------------------ 
//          DIALOG FUNCTIONS
// ------------------------------------

void SetResource(char *fname)
{
  StrCopy(rscfile,fname);
}

int DetectField(FORM *pFrm,int px,int py)
{

  int f,x,y;

  x=((px+SheetX)-2)/4;
  y=((py+SheetY-VOFFSET)-3)/6;

  x=x-pFrm->wx; y=y-pFrm->wy;

  for(f=0;f<pFrm->nf;f++) {
    if(x>pFrm->x1[f] && 
       x<pFrm->x2[f] && 
       y==pFrm->y[f]) {
  
         if(pFrm->protect[f]==1) {
           MsgBox("Protected field!",NULL);
           return -1;
         }
      return f;       
    }
  }

  return -1;

}


int GetChoice(char *menuname)
{
   
  DOCFILE *pD;
  Window wnd;
  int f,i=0,x,y,w,h,c;
 
  pD=OpenDoc(rscfile);

  while(ReadDocLine(pD)) {

   if(StrStr(pD->buffer,menuname)) {
      ReadDocLine(pD);
      StrCopy(WinTitle,pD->buffer);
      ReadDocLine(pD);
      x=(int)StrAToI(pD->buffer);
      ReadDocLine(pD);
      y=(int)StrAToI(pD->buffer);
      ReadDocLine(pD);
      w=(int)StrAToI(pD->buffer);
      ReadDocLine(pD);
      h=(int)StrAToI(pD->buffer);
      ReadDocLine(pD);
      f=(int)StrAToI(pD->buffer);
      ReadDocLine(pD); 

      wnd = w_open(x,y,w,h);

      while(ReadDocLine(pD)) {
        if(pD->buffer[0]=='}') break;
        printw(wnd,0,i,pD->buffer);
        i++;
      }

      if(i>0) break;
    }

  }
  
  CloseDoc(pD);
  if(i==0) return -1;

  c = k_getkey();
  w_close(wnd);

  c=((PenY+SheetY-VOFFSET)-3)/6;
  c=c-y;

  if(c<0||c>=h) return -1;

  return c;

}

FORM *OpenForm(char *rscname)
{

  int f,i=0,xc,yc;
  FORM *pFrm;
  DOCFILE *pD;

  pFrm=MemPtrNew(sizeof(FORM));

  pFrm->nf=0;
  pFrm->handled=0;

  pD=OpenDoc(rscfile);
  StrCopy(pFrm->rsc,rscname);

  while(ReadDocLine(pD)) {

   if(StrStr(pD->buffer,rscname)) {
      ReadDocLine(pD);
      StrCopy(WinTitle,pD->buffer);
      ReadDocLine(pD);
      pFrm->wx=(int)StrAToI(pD->buffer);
      ReadDocLine(pD);
      pFrm->wy=(int)StrAToI(pD->buffer);
      ReadDocLine(pD);
      pFrm->ww=(int)StrAToI(pD->buffer);
      ReadDocLine(pD);
      pFrm->wh=(int)StrAToI(pD->buffer);

      ReadDocLine(pD);
// focus
      ReadDocLine(pD); // }
      pFrm->wnd = w_open(pFrm->wx,pFrm->wy,pFrm->ww,pFrm->wh);
      
      i=0; /* read items */
      for(yc=0;yc<64;yc++) {
        pD->buffer[0]=0; xc=0;

        ReadDocLine(pD);
        if(pD->buffer[0]=='}') break;
        if(StrLen(pD->buffer)<3) continue;
        printw(pFrm->wnd,0,yc,pD->buffer);
     
        while(xc<strlen(pD->buffer)) {
          while(pD->buffer[xc]==' ') xc++;

          pFrm->y[i]=yc;
          xc = FindTstart(pD->buffer,xc);
          if(xc>76) break;

          pFrm->x1[i]=xc;
          xc = FindTend(pD->buffer,xc);

          pFrm->x2[i]=xc;

          pFrm->buffer[i]=MemPtrNew(80);
          pFrm->buffer[i][0]=0;
          pFrm->protect[i]=0;
          i++;
        }
      }
      if(i>0) break;

    }
  }

  CloseDoc(pD);
  if(i==0) return NULL;

  pFrm->nf = i;
  return pFrm;

}

int HandleForm(FORM *pFrm)
{

  int k=-1,i=0,f;
  char buf[80];

  // Draw field data
  vshift=FLDSHIFT;
  for(f=0;f<pFrm->nf;f++) {
    printw(pFrm->wnd,pFrm->x1[f],pFrm->y[f],pFrm->buffer[f]);
  }
  vshift=0;

  while(1) {
    k=k_getkey();
    if(k==_ESC||k==_F10||k==_ENTER) break;

    if(PenX!=-1) {
      f = DetectField(pFrm,PenX,PenY);

      if(f!=-1) {
        StrCopy(buf,pFrm->buffer[f]);

        if(GetInput("Input",buf)) {
          StrCopy(pFrm->buffer[f],buf);
          vshift=FLDSHIFT;
          printw(pFrm->wnd,pFrm->x1[f],pFrm->y[f],pFrm->buffer[f]);
          vshift=0;
        }
        DisplaySheet(SheetX,SheetY);    
      }
    }
  }
  pFrm->handled=1;
  return k;
}

void CloseForm(FORM *pFrm)
{

  int f;

  if(pFrm->handled==1)
    w_close(pFrm->wnd);

  for(f=0;f<pFrm->nf;f++) {
    MemPtrFree(pFrm->buffer[f]);     
  }

  MemPtrFree(pFrm); 

}

void ProtectField(FORM *pFrm, int Item, int status)
{
  pFrm->protect[Item] = (char)status;
}

char *GetField(FORM *pFrm, int Item, char *buffer)
{
  if(Item<pFrm->nf)
    StrCopy(buffer,pFrm->buffer[Item]);

  return buffer;
}

void SetField(FORM *pFrm, int Item, char *string)
{
  if(Item<pFrm->nf)
    StrCopy(pFrm->buffer[Item],string);
}


// ------------------------------------ 
//       Get Resource string
// ------------------------------------

char *GetResource(int type, int id, char *s)
{

  int x=0,b=0,d=4;
  DOCFILE *pDoc;
  char name[20],idbuf[6];


 if(type==STR) StrCopy(name,"[STRINGS]");

 if(type==CFG) StrCopy(name,"[CONFIG]");

  pDoc=OpenDoc(rscfile);

  while(ReadDocLine(pDoc)) {
    if(StrStr(pDoc->buffer,name)) {
      while(ReadDocLine(pDoc)) {

        if(pDoc->buffer[3]!=':') continue;

        idbuf[0]=pDoc->buffer[0];
        idbuf[1]=pDoc->buffer[1];
        idbuf[2]=pDoc->buffer[2];
        idbuf[3]=0;
        x=atoi(idbuf);

        if(id==x) {
          strcpy(s,pDoc->buffer);
          StripLF(s);

          // strip ID
          while(s[b]) s[b++]=s[d++];

          CloseDoc(pDoc);
          return s;
        }
        pDoc->buffer[0]=0;
      }
    }
  }

  CloseDoc(pDoc);
  return NULL;

}

// ------------------------------------ 
//      MAIN-FORM MENU PROCESS
// ------------------------------------

static Boolean MainFormMenuProcess(Word command) 
{ 

  Boolean handled = false; 
  EventType evt;
 
  switch (command) 
  { 
	case MenuAbout: 
		MenuEraseStatus (0); 
          FrmCustomAlert(AboutAlert,NULL,NULL,NULL);
		handled = true; 
		break; 

	case MenuQuit:
          KEY = _F10;
 		handled = true; 
		break; 

     case _ESC:     
          KEY = _ESC;
 		handled = true; 
		break; 

	case _F1:
          KEY = _F1;
 		handled = true; 
		break; 

	case _F2:
          KEY = _F2;
 		handled = true; 
		break; 

	case _F3:
          KEY = _F3;
 		handled = true; 
		break; 

	case _F4:
          KEY = _F4;
 		handled = true; 
		break; 

	case _F5:
          KEY = _F5;
 		handled = true; 
		break; 

	case _F6:
          KEY = _F6;
 		handled = true; 
		break; 

	case _F7:
          KEY = _F7;
 		handled = true; 
		break; 

	case _F8:
          KEY = _F8;
 		handled = true; 
		break; 

	case _F9:
          KEY = _F9;
 		handled = true; 
		break; 

	case _F10:
     case _OK:
          KEY = _F10;
 		handled = true; 
		break; 

     case _ENTER:
          KEY = _ENTER;
 		handled = true; 
		break; 

  } 

  return handled; 

} 

// ------------------------------------ 
//          MAIN-FORM HANDLER
// ------------------------------------

static Boolean MainFormHandleEvent(EventPtr eventP) 
{ 
  Boolean handled = false; 
  FormPtr frmP; 
 
  switch (eventP->eType)  
  { 
	case frmOpenEvent: 
		frmP = FrmGetActiveForm(); 
		FrmDrawForm(frmP); 
		handled = true; 
		break; 

	case menuEvent: 
		return MainFormMenuProcess(eventP->data.menu.itemID);  

     case penDownEvent:
          if(eventP->screenY>160) return false;
          PanSheet(3,8,&SheetX,&SheetY);
          return true;

     default: 
		break; 
		 
  } 
	 
  return handled; 
} 
 
// ------------------------------------ 
//          APP HANDLE EVENT
// ------------------------------------

static Boolean AppHandleEvent( EventPtr evtP)
{
  Word formId;
  FormPtr frmP;

  if (evtP->eType==frmLoadEvent)
  {
    formId = evtP->data.frmLoad.formID;
    frmP = FrmInitForm(formId);
    FrmSetActiveForm(frmP);

    switch (formId)
    {
      case MainForm:
		 FrmSetEventHandler (frmP, MainFormHandleEvent);
		 break;

      default:
		 break;
    }
    return true;
  }

  return false;
}

// ------------------------------------ 
//           VIRTUAL GETKEY
// ------------------------------------
 
int k_getkey(void)
{

  int k;
  Word error;
  EventType evt;

  DisplaySheet(SheetX,SheetY);

  while(KEY==0) {
    EvtGetEvent(&evt,evtWaitForever);
    if(evt.eType == appStopEvent) KEY=_F10;

    if(!SysHandleEvent(&evt))
	 if(!MenuHandleEvent(0, &evt, &error))
        if(!AppHandleEvent(&evt))
	     FrmDispatchEvent(&evt);
  }

  k=KEY; KEY=0;
  return k;

}

// ------------------------------------ 
//           Palm  M A I N
// ------------------------------------


DWord PilotMain( Word cmd, Ptr cmdPBP, Word launchFlags) 
{

  FormPtr frmP;
  Word fID=200;
  FONTFILE *pFnt;

  switch (cmd)
  {
    case sysAppLaunchCmdNormalLaunch:
      
      // Open Ffs library
      if(SysLibFind("Ffs.lib", &FfsRef)!=0)
        SysLibLoad('libr','FfsL',&FfsRef);

      FfsLibOpen(FfsRef);

      // init main form
      WinTitle[0]=0;
      frmP = FrmInitForm(MainForm);
	 FrmSetEventHandler (frmP, MainFormHandleEvent);
      FrmSetActiveForm(frmP);
      FrmDrawForm(frmP);

      pStd = OpenStdout(0,VOFFSET,160,160-VOFFSET);
      pLPT = NewDoc("printer.log");
      pFnt = LoadFont("hkfont",200);
      fID  = FntSetFont(200);
      pPassword=MemPtrNew(30);

      CreateSheet();
      Main();

      FntSetFont(fID);
      DiscardFont(pFnt);
      CloseStdout(pStd);
      CloseDoc(pLPT);
      MemPtrFree(pPassword);

      FfsLibClose(FfsRef);
      SysLibRemove(FfsRef); 
	 break;

    default:
	 break;
  }
  return 0;
}
 
